/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.tab;

import com.google.common.base.Strings;
import cz.insophy.inplan.tab.PropertySetter;
import cz.insophy.inplan.tab.PropertySetterFactory;
import cz.insophy.inplan.tab.ann.CustomError;
import cz.insophy.inplan.tab.ann.Datetime;
import cz.insophy.inplan.tab.ann.DefaultBooleanValue;
import cz.insophy.inplan.tab.ann.DefaultDoubleValue;
import cz.insophy.inplan.tab.ann.DefaultIntValue;
import cz.insophy.inplan.tab.ann.DefaultLongValue;
import cz.insophy.inplan.tab.ann.DefaultStringValue;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertySetters {
    private static final Logger log = LoggerFactory.getLogger(PropertySetters.class);

    public static <T> List<PropertySetter<T>> createFor(Class<?> cls, PropertySetterFactory<T> setterFactory) {
        Field[] fields = cls.getFields();
        ArrayList<PropertySetter<T>> res = new ArrayList<PropertySetter<T>>(fields.length);
        for (Field field : fields) {
            Object defaultValue;
            Class<?> t = field.getType();
            boolean nullable = ((Nullable[])field.getAnnotationsByType(Nullable.class)).length > 0;
            PropertySetter<T> basePs = switch (t.getTypeName()) {
                case "java.lang.String" -> setterFactory.createStringSetter(field);
                case "int" -> setterFactory.createPrimIntSetter(field);
                case "java.lang.Integer" -> setterFactory.createIntegerSetter(field);
                case "long" -> {
                    if (field.getAnnotation(Datetime.class) != null) {
                        yield setterFactory.createPrimLongDateSetter(field);
                    }
                    throw new IllegalStateException("Unsupported field type " + t.getTypeName());
                }
                case "java.lang.Long" -> {
                    if (field.getAnnotation(Datetime.class) != null) {
                        yield setterFactory.createLongDateSetter(field);
                    }
                    throw new IllegalStateException("Unsupported field type " + t.getTypeName());
                }
                case "double" -> setterFactory.createPrimDoublePropertySetter(field);
                case "java.lang.Double" -> setterFactory.createDoublePropertySetter(field);
                case "boolean" -> setterFactory.createPrimBooleanPropertySetter(field);
                case "java.lang.Boolean" -> setterFactory.createBooleanPropertySetter(field);
                default -> throw new IllegalStateException("Unsupported field type " + t.getTypeName());
            };
            Annotation defaultValueAnnotation = switch (t.getTypeName()) {
                case "java.lang.String" -> field.getAnnotation(DefaultStringValue.class);
                case "java.lang.Integer", "int" -> field.getAnnotation(DefaultIntValue.class);
                case "java.lang.Long", "long" -> field.getAnnotation(DefaultLongValue.class);
                case "java.lang.Double", "double" -> field.getAnnotation(DefaultDoubleValue.class);
                case "java.lang.Boolean", "boolean" -> field.getAnnotation(DefaultBooleanValue.class);
                default -> throw new IllegalStateException("Unsupported field type " + t.getTypeName());
            };
            try {
                defaultValue = defaultValueAnnotation != null ? defaultValueAnnotation.annotationType().getMethod("value", new Class[0]).invoke((Object)defaultValueAnnotation, new Object[0]) : null;
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalStateException("Cannot extract default value for " + field);
            }
            PropertySetter<T> ps = nullable || defaultValue != null ? new DefaultValuePropertySetter<T>(field, basePs, defaultValue) : new NullChecker<T>(basePs);
            res.add(ps);
            log.debug("Created field for class {}: {} - {} {}", cls.getSimpleName(), field.getName(), t.getTypeName(), nullable ? "nullable" : "");
        }
        return res;
    }

    private static class DefaultValuePropertySetter<T>
    implements PropertySetter<T> {
        private final Field field;
        private final PropertySetter<T> parent;
        private final Object defaultValue;

        DefaultValuePropertySetter(Field field, PropertySetter<T> parent, Object defaultValue) {
            this.field = field;
            this.parent = parent;
            this.defaultValue = defaultValue;
        }

        @Override
        public boolean parse(T s2, @Nonnull Object target) throws IllegalAccessException, ParseException {
            if (!this.parent.parse(s2, target)) {
                this.field.set(target, this.defaultValue);
            }
            return true;
        }

        @Override
        public String getFieldName() {
            return this.parent.getFieldName();
        }

        @Override
        @Nullable
        public String getCustomError() {
            return this.parent.getCustomError();
        }
    }

    private static class NullChecker<T>
    implements PropertySetter<T> {
        private final PropertySetter<T> parent;

        NullChecker(PropertySetter<T> parent) {
            this.parent = parent;
        }

        @Override
        public boolean parse(@Nullable T s2, @Nonnull Object target) throws IllegalAccessException, ParseException {
            if (!this.parent.parse(s2, target)) {
                throw new RuntimeException("null or empty value in a non-null field");
            }
            return true;
        }

        @Override
        public String getFieldName() {
            return this.parent.getFieldName();
        }

        @Override
        @Nullable
        public String getCustomError() {
            return this.parent.getCustomError();
        }
    }

    public static abstract class AbstractStringPropertySetter
    extends AbstractFieldPropertySetter<String> {
        protected AbstractStringPropertySetter(Field field) {
            super(field);
        }

        @Override
        public boolean parse(@Nullable String s2, @Nonnull Object target) throws IllegalAccessException, ParseException {
            if (Strings.isNullOrEmpty(s2)) {
                return false;
            }
            this.parseString(s2, target);
            return true;
        }

        protected abstract void parseString(@Nonnull String var1, @Nonnull Object var2) throws IllegalAccessException, ParseException;
    }

    public static abstract class AbstractFieldPropertySetter<T>
    implements PropertySetter<T> {
        final Field field;
        final String customError;

        protected AbstractFieldPropertySetter(Field field) {
            this.field = field;
            field.setAccessible(true);
            CustomError custErrAnn = field.getAnnotation(CustomError.class);
            this.customError = custErrAnn != null ? custErrAnn.value() : null;
        }

        @Override
        public String getFieldName() {
            return this.field.getName();
        }

        @Override
        public String getCustomError() {
            return this.customError;
        }
    }
}

